<?php
/* --------------------------------------------------------------
 Kernel.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel;

use Gambio\Core\Application\Application;

/**
 * Interface Kernel
 *
 * @package Gambio\Core\Application\Kernel
 */
interface Kernel
{
    /**
     * Bootstrap the application.
     * Setup for all base building blocks of the gambio application. The bootstrap method is responsible to
     * setup service providers, route definitions, middleware, inflectors and so on.
     *
     * @param Application  $application
     * @param Bootstrapper $bootstrapper
     */
    public function bootstrap(Application $application, Bootstrapper $bootstrapper): void;
    
    
    /**
     * Runs the application.
     */
    public function run(): void;
}